select   daten.Bezeichnung,
         daten.Freigabe,
         daten.Kuerzel,
         daten.Vorgangskennzeichen,

         sum(daten.Jahr1) as "Jahressumme vor 5 Jahren",
         sum(daten.Jahr2) as "Jahressumme vor 4 Jahren",
         sum(daten.Jahr3) as "Jahressumme vor 3 Jahren",
         sum(daten.Jahr4) as "Jahressumme vor 2 Jahren",
         sum(daten.Jahr5) as "Jahressumme vor 1 Jahr"

from     (
         select   'Basiszahl 31 und 31.2' as "Bezeichnung",

                  case s.freigabe when 1 then 'ja' else 'nein' end as "Freigabe",
                  isnull(k.kennzeichen,'(ohne)') as "Kuerzel",
                  isnull(k.bezeichnung,'(ohne)') as "Vorgangskennzeichen",

                  count(distinct(case when m.vondatum <= cast('31.12.' + cast(year(getdate())-5 as char(4)) as datetime) 
                                      and (m.bisdatum >= cast('01.01.' + cast(year(getdate())-5 as char(4)) as datetime) or m.bisdatum is null) 
                                      then h.massnahme else null end)) as "Jahr1",
                             
                  count(distinct(case when m.vondatum <= cast('31.12.' + cast(year(getdate())-4 as char(4)) as datetime) 
                                      and (m.bisdatum >= cast('01.01.' + cast(year(getdate())-4 as char(4)) as datetime) or m.bisdatum is null)
                                      then h.massnahme else null end)) as "Jahr2",
                             
                  count(distinct(case when m.vondatum <= cast('31.12.' + cast(year(getdate())-3 as char(4)) as datetime) 
                                      and (m.bisdatum >= cast('01.01.' + cast(year(getdate())-3 as char(4)) as datetime) or m.bisdatum is null) 
                                      then h.massnahme else null end)) as "Jahr3",   
                             
                  count(distinct(case when m.vondatum <= cast('31.12.' + cast(year(getdate())-2 as char(4)) as datetime) 
                                      and (m.bisdatum >= cast('01.01.' + cast(year(getdate())-2 as char(4)) as datetime) or m.bisdatum is null)
                                      then h.massnahme else null end)) as "Jahr4",
                             
                  count(distinct(case when m.vondatum <= cast('31.12.' + cast(year(getdate())-1 as char(4)) as datetime) 
                                      and (m.bisdatum >= cast('01.01.' + cast(year(getdate())-1 as char(4)) as datetime) or m.bisdatum is null) 
                                      then h.massnahme else null end)) as "Jahr5"   
                                      
         from     n_vorgang v inner join n_vorgmassnahme h on v.vorgangsnummer = h.vorgang
                              inner join n_statistikbogen s on h.massnahme = s.aktion      
                              inner join n_massnahme m on h.massnahme = m.massnahmennummer
                              left join n_kennz k on v.kennz_fk = k.lfdnr

         where    substring(s.feld,39,1) = '1' 

         group by case s.freigabe when 1 then 'ja' else 'nein' end,
                  isnull(k.kennzeichen,'(ohne)'),
                  isnull(k.bezeichnung,'(ohne)')

         ) as daten
         
group by daten.Bezeichnung,
         daten.Freigabe,
         daten.Kuerzel,
         daten.Vorgangskennzeichen

order by daten.Bezeichnung,
         daten.Freigabe,
         daten.Kuerzel,
         daten.Vorgangskennzeichen